<?php
require_once "bdd.php";

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    exit("Only POST allowed");
}

$action = $_POST['action'] ?? '';
$id = $_POST['id'] ?? null;

if (!$action) exit("Missing parameters");

// Users
if ($action && $action === 'create_user') {
    $table = "users";

    $email = $_POST['user'] ?? '';
    $pwd = $_POST['pwd'] ?? '';
    $name = $_POST['name'] ?? '';
    $status = $_POST['status'] ?? '';
    $type = $_POST['type'] ?? '';

    if (!$email || !$pwd || !$name || !$status || !$type) {
        exit("Missing fields");
    }

    // Sanitizar
    $email = mysqli_real_escape_string($link, $email);
    $pwd = mysqli_real_escape_string($link, $pwd);
    $name = mysqli_real_escape_string($link, $name);
    $status = mysqli_real_escape_string($link, $status);
    $type = mysqli_real_escape_string($link, $type);

    // Insertar
    $sql = "INSERT INTO $table (email, pwd, name, status, type) 
            VALUES ('$email', '$pwd', '$name', '$status', '$type')";
    $result = mysqli_query($link, $sql);

    if (!$result) {
        http_response_code(500);
        exit("Insert failed: " . mysqli_error($link));
    }

    $newId = mysqli_insert_id($link);
    $select = mysqli_query($link, "SELECT * FROM $table WHERE id = $newId LIMIT 1");
    $row = mysqli_fetch_assoc($select);

    echo json_encode($row);
    exit;
}
if ($action && $action === 'delete_user') {
    $table = "users";

    if (!$id) exit("Missing ID for delete");

    $sql = "DELETE FROM $table WHERE id = $id";
    $result = mysqli_query($link, $sql);

    if (!$result) {
        http_response_code(500);
        exit("Delete failed: " . mysqli_error($link));
    }

    echo "Deleted user with ID $id";
    exit;
}
if ($action && $action === 'get_user') {
    $table = "users";
    if (!$id) exit("Missing ID");

    $query = mysqli_query($link, "SELECT * FROM $table WHERE id = $id LIMIT 1");
    if (!$query || mysqli_num_rows($query) === 0) {
        http_response_code(404);
        exit("User not found");
    }

    $row = mysqli_fetch_assoc($query);
    echo json_encode($row);
    exit;
}
if ($action && $action === 'edit_user') {
    $table = "users";

    if (!$id) exit("Missing ID for edit");

    // Recibir y validar campos
    $email = $_POST['user'] ?? '';
    $pwd = $_POST['pwd'] ?? '';
    $name = $_POST['name'] ?? '';
    $status = $_POST['status'] ?? '';
    $type = $_POST['type'] ?? '';

    if (!$email || !$pwd || !$name || !$status || !$type) {
        exit("Missing fields");
    }

    // Sanitizar
    $email = mysqli_real_escape_string($link, $email);
    $pwd = mysqli_real_escape_string($link, $pwd);
    $name = mysqli_real_escape_string($link, $name);
    $status = mysqli_real_escape_string($link, $status);
    $type = mysqli_real_escape_string($link, $type);

    // Update
    $sql = "UPDATE $table SET 
            email = '$email', 
            pwd = '$pwd', 
            name = '$name', 
            status = '$status', 
            type = '$type' 
            WHERE id = $id";

    $result = mysqli_query($link, $sql);
    if (!$result) {
        http_response_code(500);
        exit("Update failed: " . mysqli_error($link));
    }

    $select = mysqli_query($link, "SELECT * FROM $table WHERE id = $id LIMIT 1");
    $row = mysqli_fetch_assoc($select);

    echo json_encode(array(
        'status' => 'success',
        'data' => $row
    ));
    exit;
}
if ($action === 'export_users_csv') {
    $table = "users";

    $result = mysqli_query($link, "SELECT * FROM $table ORDER BY id ASC");

    if (!$result) {
        http_response_code(500);
        exit("Query failed");
    }

    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=users_' . date('Y-m-d_H-i-s') . '.csv');

    $output = fopen('php://output', 'w');

    // Encabezados
    fputcsv($output, ['id', 'created', 'updated', 'email', 'pwd', 'name', 'status', 'type']);

    while ($row = mysqli_fetch_assoc($result)) {
        fputcsv($output, [
            $row['id'],
            $row['created'],
            $row['updated'],
            $row['email'],
            $row['pwd'],
            $row['name'],
            $row['status'],
            $row['type']
        ]);
    }

    fclose($output);
    exit;
}

// SKUs
if ($action === 'create_sku') {
    $table = "skus";

    $sku = $_POST['sku'] ?? '';
    $name = $_POST['name'] ?? '';
    $category = $_POST['category'] ?? '';

    if (!$sku || !$name || !$category) {
        exit("Missing fields");
    }

    // Sanitizar
    $sku = mysqli_real_escape_string($link, $sku);
    $name = mysqli_real_escape_string($link, $name);
    $category = mysqli_real_escape_string($link, $category);

    // Insertar
    $sql = "INSERT INTO $table (sku, name, category) 
            VALUES ('$sku', '$name', '$category')";
    $result = mysqli_query($link, $sql);

    if (!$result) {
        http_response_code(500);
        exit("Insert failed: " . mysqli_error($link));
    }

    $newId = mysqli_insert_id($link);
    $select = mysqli_query($link, "SELECT * FROM $table WHERE id = $newId LIMIT 1");
    $row = mysqli_fetch_assoc($select);

    echo json_encode($row);
    exit;
}
if ($action === 'get_sku') {
    $table = "skus";

    if (!$id) exit("Missing ID");

    $query = mysqli_query($link, "SELECT * FROM $table WHERE id = $id LIMIT 1");
    if (!$query || mysqli_num_rows($query) === 0) {
        http_response_code(404);
        exit("SKU not found");
    }

    $row = mysqli_fetch_assoc($query);
    echo json_encode($row);
    exit;
}
if ($action === 'edit_sku') {
    $table = "skus";

    if (!$id) exit("Missing ID for edit");

    $sku = $_POST['sku'] ?? '';
    $name = $_POST['name'] ?? '';
    $category = $_POST['category'] ?? '';

    if (!$sku || !$name || !$category) {
        exit("Missing fields");
    }

    // Sanitizar
    $sku = mysqli_real_escape_string($link, $sku);
    $name = mysqli_real_escape_string($link, $name);
    $category = mysqli_real_escape_string($link, $category);

    // Update
    $sql = "UPDATE $table SET 
            sku = '$sku', 
            name = '$name', 
            category = '$category' 
            WHERE id = $id";

    $result = mysqli_query($link, $sql);
    if (!$result) {
        http_response_code(500);
        exit("Update failed: " . mysqli_error($link));
    }

    $select = mysqli_query($link, "SELECT * FROM $table WHERE id = $id LIMIT 1");
    $row = mysqli_fetch_assoc($select);

    echo json_encode(array(
        'status' => 'success',
        'data' => $row
    ));
    exit;
}
if ($action === 'delete_sku') {
    $table = "skus";

    if (!$id) exit("Missing ID for delete");

    $sql = "DELETE FROM $table WHERE id = $id";
    $result = mysqli_query($link, $sql);

    if (!$result) {
        http_response_code(500);
        exit("Delete failed: " . mysqli_error($link));
    }

    echo "Deleted SKU with ID $id";
    exit;
}
if ($action === 'export_skus_csv') {
    $table = "skus";

    $result = mysqli_query($link, "SELECT * FROM $table ORDER BY id ASC");

    if (!$result) {
        http_response_code(500);
        exit("Query failed");
    }

    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=skus_' . date('Y-m-d_H-i-s') . '.csv');

    $output = fopen('php://output', 'w');

    fputcsv($output, ['id', 'created', 'updated', 'sku', 'name', 'category']);

    while ($row = mysqli_fetch_assoc($result)) {
        fputcsv($output, [
            $row['id'],
            $row['created'],
            $row['updated'],
            $row['sku'],
            $row['name'],
            $row['category']
        ]);
    }

    fclose($output);
    exit;
}

//Etc demás metodos para demás modulos

exit("Unknown action: $action");